<?php

namespace Database\Factories;

use App\Models\Brand;
use App\Models\Category;
use App\Models\Tag;
use Illuminate\Database\Eloquent\Factories\Factory;
use Faker;

class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $faker1 = Faker\Factory::create('ar_JO');

        return [
            'name_ar' => $faker1->firstName(),
            'name_en'=> $this->faker->text(8),
            'category_id'=> Category::inRandomOrder()->first()->id,
            'tag_id'=> Tag::inRandomOrder()->first()->id,
            'description_ar'=>$faker1->text(),
            'description_en'=>$this->faker->text(),
            'purchasing_price'=> $this->faker->numberBetween(50, 200),
            'selling_price'=> $this->faker->numberBetween(150, 400),
            'quantity'=> $this->faker->randomDigit(),
            'main_photo'=> $this->faker->randomElement(['images/products/prod-1.webp','images/products/prod-2.webp']),
        ];
    }
}
