<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\User;

class OrderFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'user_id' => User::inRandomOrder()->first()->id,
            'total_price' => $this->faker->randomDigit(),
            'paid'=> $this->faker->boolean(),
            'payment_stauts' => $this->faker->randomElement(['success','fail','pending']),
            'deliever_stauts' => $this->faker->randomElement(['pending','in_way'])
            //
        ];
    }
}
