<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Exception;
use App\Models\Photo;
use App\Traits\PhotoTrait;
use Illuminate\Support\Carbon;

class ProductController extends Controller
{
    use PhotoTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products=Product::with('category','tag','photos')->paginate(20);
        return response()->json($products,200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator=Validator::make($request->all(),
        [
            'name_ar'=>'required|max:255',
            'name_en'=>'required|max:255',
            'category_id'=>'required|numeric',
            'description_ar'=>'nullable',
            'description_en'=>'nullable',
            'purchasing_price'=>'required|numeric',
            'selling_price'=>'required|numeric',
            'quantity'=>'required|numeric',
            'main_photo' =>'image|required|max:1024|mimes:jpeg,bmp,png,webp,svg|dimensions:min_width=600,min_height=600',
            'sub_photos' => 'array|max:4',
            'sub_photos.*' =>'image|max:1024|mimes:jpeg,bmp,png,webp,svg|dimensions:min_width=600,min_height=600',
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }

        try{
        $photo=$this->saveImage($request->main_photo,'photo','images/products');
         $product= Product::create([
            'name_ar'=>$request->name_ar,
            'name_en'=>$request->name_en,
            'category_id'=>$request->category_id,
            'description_ar'=>$request->description_ar,
            'description_en'=>$request->description_en,
            'purchasing_price'=>$request->purchasing_price,
            'selling_price'=>$request->selling_price,
            'quantity'=>$request->quantity,
            'main_photo'=>$photo
            ]
        );

        if($request->hasfile('sub_photos'))
        {
        $files= $request->file('sub_photos');
        foreach($files as $file)
        {
        $photo_path= $this->saveImage($file,'photo','images/products');
        $photo=Photo::create([
            'product_id'=>$product->id,
            'path'=>$photo_path
        ]);
 
        }
         }
        return response()->json($product,201);
        }
        catch(Exception $ex){
            return response()->json(["message"=>$ex->getMessage()],400);
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        
            $product_id = request('id');

            if (!empty(request('lang'))) {
                $lang=request('lang');
            }
            else{
                $lang='en';
            }
            $product= Product::select('id',"name_$lang AS name",'category_id',
            'tag_id',"description_$lang AS description",'selling_price','quantity','main_photo')
            ->with("category:id,category_id,name_$lang AS name","tag:id,name_$lang AS name,background_color",'photos')
            ->find($product_id);
            if ($product !=null){
                return response($product,200);
            }
            else {
                return response()->json(['error'=>' this id does not exist '],404);
            }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Product $product)
    {
        $validator=Validator::make($request->all(),
        [
            'name_ar'=>'required|max:255',
            'name_en'=>'required|max:255',
            'category_id'=>'required|numeric',
            'description_ar'=>'nullable',
            'description_en'=>'nullable',
            'purchasing_price'=>'required|numeric',
            'selling_price'=>'required|numeric',
            'quantity'=>'required|numeric',
            'main_photo' =>'nullable|image|max:1024|mimes:jpeg,bmp,png,webp,svg|dimensions:min_width=1280,min_height=700',
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $product_id = request('id');
        $product= Product::with('photos')->find($product_id);
        $photo= request('main_photo');
        if ($product !=null){
            if ( $request->hasFile('main_photo')) 
        
        {
            $destination=$product->main_photo;
                    if(File::exists($destination))
                    {
                       File::delete($destination);
                    }
                    $photo=$this->saveImage($photo,'photo','images/categories');}
                    else{
                        $photo=$product->photo;
                    }
            $product->update([
                'name_ar'=>$request->name_ar,
                'name_en'=>$request->name_en,
                'category_id'=>$request->category_id,
                'tag_id'=>$request->tag_id,
                'description_ar'=>$request->description_ar,
                'description_en'=>$request->description_en,
                'purchasing_price'=>$request->purchasing_price,
                'selling_price'=>$request->selling_price,
                'quantity'=>$request->quantity,
                'main_photo'=>$photo
                ]
            );
            return response($product,200);
        }
        else {
            return response()->json(['error'=>' this id does not exit to modify '],404);
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {

     $product_id = request('id');
     $product= Product::find($product_id);
     if(Product::has('orders')->where('id',$product_id)->count()===1 ){
         return response()->json(['message' => "You cannot delete this product"],400);
       }
       $product= Product::with('photos')->find($product_id);
       if($product ==null){
         return response()->json(['message' => 'This product is not exist'],404);
       }
       $destination=$product->main_photo;
       if(File::exists($destination))
       {
          File::delete($destination);
       }
       foreach($product->photos as $photo){
        $destination=$photo->path;
        if(File::exists($destination))
        {
           File::delete($destination);
        }
       }
     $product->delete();

     return response()->json(['message' => "Product deleted successfully"],200);

    }


    public function getRelatedProducts()
    {

        if (!empty(request('lang'))) {
            $lang=request('lang');
        }
        else{
            $lang='en';
        }
        $product_id= request('id');
        $product=Product::find($product_id);

        $products=Product::select('id',"name_$lang AS name",'category_id',
        'tag_id',"description_$lang AS description",'selling_price',
        'quantity','main_photo')
        ->where('category_id',$product->category_id)
        ->where('id', '!=', $product->id)
         //We can  suggest to user products by most ordered product
        ->withCount('orders')
        ->with("category:id,name_$lang AS name","tag:id,name_$lang AS name,background_color")
        ->orderBy('orders_count','desc')->paginate(8);

        //We can also suggest to user products by most liked product

        // ->withCount('likes')
        // ->with("sub_category:id,category_id,name_$lang AS name","sub_category.category:id,name_$lang AS name","brand:id,name_$lang AS name",'billing_account',"tag:id,name_$lang AS name,background_color")
        // ->orderBy('likes_count','desc')->paginate(8);

        return response()->json($products,200);

    }     

    public function getMostOrderedProducts()
    {

        if (!empty(request('lang'))) {
            $lang=request('lang');
        }
        else{
            $lang='en';
        }
        $products=Product::select('id',"name_$lang AS name",'category_id',
        'tag_id',"description_$lang AS description",'selling_price',
        'quantity','main_photo')
        ->withCount('orders')
        ->with("category:id,name_$lang AS name","tag:id,name_$lang AS name,background_color")
        ->orderBy('orders_count','desc')->paginate(10);

        return response()->json($products,200);

    }   
       
}

