<?php

namespace App\Http\Controllers;

use App\Models\Photo;
use App\Models\Product;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use App\Traits\PhotoTrait;
use Exception;


class PhotoController extends Controller
{
    use PhotoTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Photo  $photo
     * @return \Illuminate\Http\Response
     */
    public function show(Photo $photo)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Photo  $photo
     * @return \Illuminate\Http\Response
     */
    public function edit(Photo $photo)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Photo  $photo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Photo $photo)
    {
        //
        $product_id = request('id');
        //   $product_id=Photo::select('product_id')->where('id',$photo_id )->first();
            $count_photo=Product::withCount('photos')->where('id',$product_id)->first();
            $max = 4 - $count_photo->photos_count;

          $validator=Validator::make($request->all(),
          [
            'sub_photos' => 'array|max:' . $max,
            'sub_photos.*' =>'image|max:1024|mimes:jpeg,bmp,png,webp,svg',
          ],[
            'sub_photos.max'=>"The sub photos must not have more than 4 items."
          ]);
  
          if($validator->fails()){
              return response()->json($validator->errors(),400);
          }
          $files= $request->file('sub_photos');
          foreach($files as $file)
            {
          $photo_path= $this->saveImage($file,'photo','images/products');
          $photo=Photo::create([
              'product_id'=>$product_id,
              'path'=>$photo_path
          ]);
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Photo  $photo
     * @return \Illuminate\Http\Response
     */
        public function destroy(Photo $photo)
    {
        //
        try {
            $photo_id = request('id');
            $photo= Photo::find($photo_id);

              if($photo ==null){
                return response()->json(['message' => 'This Photo is not exist'],404);
              }

            $destination=$photo->path;
            if(File::exists($destination))
            {
               File::delete($destination);
            }
            $photo->delete();
            return response()->json([$photo,'status'=>"success",'message' => "Photo deleted successfully"],200);
    
 }catch (\Exception $ex) {
         return response()->json(["message"=>$ex->getMessage()], 400);
     }}
    
}
