<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\SubCategory;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Exception;
use App\Traits\PhotoTrait;


class CategoryController extends Controller
{
    use PhotoTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $categories=Category::all();
        return response()->json($categories,200);
        
    }

    public function getCategoriesNamesforDropDown()
    {
        //
        $categories=Category::select('id','name_ar','name_en')->get();
        return response()->json($categories,200);
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Support\Facades\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
   
        $validator=Validator::make($request->all(),
        [
            'name_ar'=>'required|max:255',
            'name_en'=>'required|max:255',
            'photo' =>'image|mimes:jpeg,bmp,png,webp,svg|dimensions:min_width=1280,min_height=700',
            
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }

        try{
        $photo=$this->saveImage($request->photo,'category','images/categories');
         $category= Category::create([
            'name_ar'=>$request->name_ar,
            'name_en'=>$request->name_en,
            'photo'=>$photo,
            ]
        );


        return response()->json(['category'=>$category],201);
        }
        catch(Exception $ex){
            return response()->json(["message"=>$ex->getMessage()],400);
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function show(Category $category)
    {
        //
        $category_id = request('id');
        $category= Category::find($category_id);
        if ($category !=null){
            return response($category,200);
        }
        else {
            return response()->json(['error'=>' this id does not exist '],404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateCategoryRequest  $request
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Category $category)
    {
        //
        $validator=Validator::make($request->all(),
        [
        'name_ar'=>'required|max:255',
        'name_en'=>'required|max:255',
        'photo' =>'image|nullable|mimes:jpeg,bmp,png,webp,svg|dimensions:min_width=1280,min_height=700',
            
        ]);

        if($validator->fails()){
            return response()->json($validator->errors(),400);
        }
        $category_id = $request->id;
        $category = Category::find($category_id);
        $photo= request('photo');
        if ($category !=null){
            if ( $request->hasFile('photo')) 
        
        {
            $destination=$category->photo;
                    if(File::exists($destination))
                    {
                       File::delete($destination);
                    }
                    $photo=$this->saveImage($photo,'photo','images/categories');}
                    else{
                        $photo=$category->photo;
                    }
            $category->update([
                'name_ar' => $request->name_ar ,
                'name_en' => $request->name_en ,
                'photo' => $photo ,

                ]
            );

            return response($category,200);

        }
        else {
            return response()->json(['error'=>' this id does not exit to modify '],404);
        }
    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        //
        try {
            $category_id = request('id');
            $category= Category::find($category_id);

              if($category ==null){
                return response()->json(['message' => 'This category is not exist'],404);
              }

            $destination=$category->photo;
            if(File::exists($destination))
            {
               File::delete($destination);
            }
            $category->delete();
            return response()->json([$category,'status'=>"success",'message' => "Category deleted successfully"],200);
    
 }catch (\Exception $ex) {
         return response()->json(["message"=>$ex->getMessage()], 400);
     }
    }
}
