<?php

namespace App\Console\Commands;

use App\Models\Product;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;


class UpdateProductsTags extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:tags';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'update products tags ';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $day = Carbon::now();
        $day =$day->sub('15 days');
        $products=Product::where('created_at','<',$day)
        ->where('tag_id',1)
        ->get();
            foreach($products as $product){
                $product->tag_id=null;
                $product->save();
            }    
        $products1=Product::withCount('likes')
        ->orderBy('likes_count','desc')->paginate(12);
            foreach($products1 as $product1){
                $product1->tag_id=2;
                $product1->save();
            }
        $products2=Product::withCount('orders')
        ->orderBy('orders_count','desc')->paginate(12);
            foreach($products2 as $product2){
                $product2->tag_id=3;
                $product2->save();
            }    
    }
}
